package com.qboxus.tictic.activitesfragments.livestreaming.activities;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceView;

import com.qboxus.tictic.Constants;
import com.qboxus.tictic.activitesfragments.livestreaming.rtc.EventHandler;

import io.agora.rtc2.video.CameraCapturerConfiguration;
import io.agora.rtc2.video.VideoCanvas;
import io.agora.rtc2.video.VideoEncoderConfiguration;

public abstract class RtcBaseActivity extends BaseActivity implements EventHandler {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        registerRtcEventHandler(this);
        configVideo();
        joinChannel();
    }


    private void configVideo() {

        VideoEncoderConfiguration configuration = new VideoEncoderConfiguration(
                VideoEncoderConfiguration.VD_1920x1080,
                VideoEncoderConfiguration.FRAME_RATE.FRAME_RATE_FPS_60,
                VideoEncoderConfiguration.STANDARD_BITRATE,
                VideoEncoderConfiguration.ORIENTATION_MODE.ORIENTATION_MODE_ADAPTIVE
        );
        configuration.advanceOptions = new VideoEncoderConfiguration.AdvanceOptions(VideoEncoderConfiguration.ENCODING_PREFERENCE.PREFER_AUTO, VideoEncoderConfiguration.COMPRESSION_PREFERENCE.PREFER_QUALITY);

        CameraCapturerConfiguration cameraCapturerConfiguration = new CameraCapturerConfiguration(CameraCapturerConfiguration.CAMERA_DIRECTION.CAMERA_FRONT);
        cameraCapturerConfiguration.cameraFocalLengthType = CameraCapturerConfiguration.CAMERA_FOCAL_LENGTH_TYPE.CAMERA_FOCAL_LENGTH_ULTRA_WIDE;
        rtcEngine().setCameraCapturerConfiguration(cameraCapturerConfiguration);
        rtcEngine().setCameraAutoFocusFaceModeEnabled(false);
        rtcEngine().setVideoEncoderConfiguration(configuration);
    }

    public void joinChannel() {
        Log.d(Constants.tag, "Check channel name : " + config().getChannelName());
        if (!TextUtils.isEmpty(config().getChannelName())) {
            rtcEngine().joinChannel(null, config().getChannelName(), "", Integer.parseInt(config().getUid()));
        }
    }

    protected SurfaceView prepareRtcVideo(int uid, boolean local) {
        SurfaceView surface = new SurfaceView(getApplicationContext());
        surface.setZOrderMediaOverlay(true);

        if (local) {
            rtcEngine().setupLocalVideo(
                    new VideoCanvas(
                            surface,
                            VideoCanvas.RENDER_MODE_HIDDEN,
                            uid)
            );
        } else {
            rtcEngine().setupRemoteVideo(
                    new VideoCanvas(
                            surface,
                            VideoCanvas.RENDER_MODE_HIDDEN,
                            uid)
            );
        }
        return surface;
    }

    protected void removeRtcVideo(int uid, boolean local) {
        if (local) {
            rtcEngine().setupLocalVideo(null);
        } else {
            rtcEngine().setupRemoteVideo(new VideoCanvas(null, VideoCanvas.RENDER_MODE_FIT, uid));
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        removeRtcEventHandler(this);
        rtcEngine().leaveChannel();
    }


}
